/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings;
import com.ibm.hwmca.fw.settings.user.StatusBackgroundConstants;
import java.util.Map;

public class ObjectBackground {
    private ObjectBackgroundSettings settings;
    private Map shortIdToStatus;
    private Map statusToShortId;
    private Map shortIdToStatusImageName;
    private Map shortIdToAttnImageName;

    ObjectBackground(Map userSettings) {
        this.settings = (ObjectBackgroundSettings)userSettings.get("com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings");
    }

    public synchronized Status getStatus(String shortId) {
        if (this.shortIdToStatus == null) {
            return null;
        }
        return (Status)this.shortIdToStatus.get(shortId);
    }

    public synchronized String getStatusImageName(String statusShortId, byte type) {
        String result = null;
        switch (type) {
            case 50: {
                result = this.settings.getUnacceptableImageName();
                break;
            }
            case 49: 
            case 55: {
                result = this.shortIdToStatusImageName != null && this.shortIdToStatusImageName.containsKey(statusShortId) ? (String)this.shortIdToStatusImageName.get(statusShortId) : this.settings.getUnacceptableImageName();
            }
        }
        return result;
    }

    public synchronized String getAttentionImageName(String taskShortId, byte type) {
        String result = null;
        if (this.shortIdToAttnImageName != null && this.shortIdToAttnImageName.containsKey(taskShortId)) {
            String imageName = (String)this.shortIdToAttnImageName.get(taskShortId);
            if (type == 51) {
                int index = imageName.indexOf(".gif");
                result = imageName.substring(0, index) + "animated.gif";
            } else {
                result = StatusBackgroundConstants.getTinyForImageName(imageName);
            }
        }
        return result;
    }

    synchronized ObjectBackgroundSettings getObjectBackgroundSettings() {
        return this.settings;
    }

    synchronized Map getShortIdToStatus() {
        return this.shortIdToStatus;
    }

    synchronized Map getStatusToShortId() {
        return this.statusToShortId;
    }

    synchronized Map getShortIdToStatusImageName() {
        return this.shortIdToStatusImageName;
    }

    synchronized Map getShortIdToAttnImageName() {
        return this.shortIdToAttnImageName;
    }

    synchronized void setObjectBackgroundSettings(ObjectBackgroundSettings s) {
        this.settings = s;
    }

    synchronized void setShortIdToStatus(Map map) {
        this.shortIdToStatus = map;
    }

    synchronized void setStatusToShortId(Map map) {
        this.statusToShortId = map;
    }

    synchronized void setShortIdToStatusImageName(Map map) {
        this.shortIdToStatusImageName = map;
    }

    synchronized void setShortIdToAttnImageName(Map map) {
        this.shortIdToAttnImageName = map;
    }
}

